<?php declare(strict_types = 1);

namespace Ceskaposta\Model;

use Exception;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\Utils\Json;
use stdClass;
use Throwable;
use Tracy\Debugger;

class ParcelsService
{
	protected ?Cache $cache = null;
	protected Storage $cacheStorage;

	public function __construct(Storage $storage)
	{
		$this->cacheStorage = $storage;
	}

	/**
	 * @return array<string, stdClass>
	 * @throws Throwable
	 */
	public function getParcelsByService(string $service): array
	{
		try {
			$list = $this->getCache()->load('service_' . $service, function(&$dep) use ($service) {
				$dep = [Cache::TAGS => ['cpost'], Cache::EXPIRE => '1 hour'];

				$list = [];
				if ($service === 'napostu') {
					$json = file_get_contents('https://api-evidence.pshk.cz/v1/cms/spedition/cpost-na-postu');
				} else if ($service === 'balikovna') {
					$json = file_get_contents('https://api-evidence.pshk.cz/v1/cms/spedition/cpost-balikovna');
				} else {
					return [];
				}

				foreach (Json::decode($json)->data as $row) {
					$list[$row->psc] = $row;
				}

				return $list;
			});
		} catch (Exception $e) {
			Debugger::log('CPOST - cannot load parcels for service ' . $service);

			return [];
		}

		return $list;
	}

	/**
	 * @param int|string $id
	 * @throws Throwable
	 */
	public function getParcelByService($id, string $service): ?stdClass
	{
		return $this->getParcelsByService($service)[$id] ?? null;
	}

	public function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, 'cpost');
		}

		return $this->cache;
	}
}
