<?php declare(strict_types = 1);

namespace Ceskaposta\Model\Entities;

use DateTime;
use EshopOrders\Model\Entities\Order;

interface ICeskaPostaOrder
{
	public function getOrder(): Order;

	public function getPostPSC(): ?string;

	public function getPostName(): ?string;

	public function getVillage(): ?string;

	public function getPartVillage(): ?string;

	public function getNumberPackage(): ?string;

	public function getExported(): ?DateTime;

	public function isExported(): bool;

	public function isPickUp(): bool;

	public function export(?DateTime $datetime = null): self;

	public function getPrefixParcelCode(): string;

	public function getTrackingUrl(): string;

	/**
	 * @return string[]
	 */
	public function getTrackingUrls(): array;

	public function resetExport(): void;

	public function getIdent(): string;

	public function getIdTransaction(): ?string;

	public function setIdTransaction(string $val): void;

	/**
	 * @return ICeskaPostaNumberPackage[]
	 */
	public function getAssociatedNumberPackages(): array;

	/**
	 * @return string[]
	 */
	public function getAllNumberPackages(): array;
}
