<?php declare(strict_types = 1);

namespace Ceskaposta\Model;

use Ceskaposta\Model\Entities\PostOfficeOrder;
use Core\Model\Helpers\BaseEntityService;

class PostOfficesOrder extends BaseEntityService
{
	protected $entityClass = PostOfficeOrder::class;

	/**
	 * @param string[]|int[] $filtrIds
	 *
	 * @return PostOfficeOrder[]
	 */
	public function getOrdersNotExported(array $filtrIds = []): array
	{
		//objednavky ktere nejsou v seznamu zpracovanych objednavek
		$ordersQuery = $this->getEr()->createQueryBuilder('who')
			->select('o, who, oad, oai, os, s')
			->join('who.order', 'o')
			->leftJoin('o.addressDelivery', 'oad')
			->leftJoin('o.addressInvoice', 'oai')
			->leftJoin('o.spedition', 'os')
			->leftJoin('os.spedition', 's')
			->where('who.exported IS NULL')
			->orderBy('o.id')->groupBy('o.id');

		if ($filtrIds !== []) {
			$ordersQuery->andWhere('who.order IN (:ids)')->setParameter('ids', $filtrIds);
		}

		return $ordersQuery->getQuery()->getResult();
	}
}
