<?php declare(strict_types = 1);

namespace Ceskaposta\Model\Subscribers;

use Ceskaposta\Model\CeskaPostaConfig;
use Ceskaposta\Model\Entities\ICeskaPostaOrder;
use Ceskaposta\Model\OrdersExported;
use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
		protected OrdersExported         $ordersExported,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!OrderHelper::canSendTrackingUrl($event->status) || !CeskaPostaConfig::load('enable')) {
			return;
		}

		/** @var ICeskaPostaOrder|null $exported */
		$exported = $this->ordersExported->getOrdersExported([$event->order->getId()])[$event->order->getId()] ?? null;

		if ($exported && $exported->getNumberPackage()) {
			$event->template->trackingUrl    = $exported->getTrackingUrl();
			$event->template->trackingNumber = $exported->getNumberPackage();
		}
	}
}
