<?php declare(strict_types = 1);

namespace Ceskaposta\Model\Subscribers;

use Ceskaposta\Model\CeskaPostaConfig;
use Ceskaposta\Model\Libs\CeskaPostaApi;
use Ceskaposta\Model\OrdersExported;
use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\OrderStatus;
use Exception;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;

class OrderSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Statuses       $statuses,
		protected OrdersExported $ordersExported,
		protected CeskaPostaApi  $orderApiService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		if (!CeskaPostaConfig::load('enable')) {
			return;
		}

		$orders = $this->ordersExported->getOrdersNotCompleted();

		$completed = [];
		foreach ($orders as $id => $uo) {
			if ($uo->getNumberPackage() === null) {
				continue;
			}
			if ($this->orderApiService->checkCompleted($uo, $uo->getNumberPackage())) {
				$completed[] = $id;
			}
		}

		if ($completed !== []) {
			try {
				$this->statuses->changeStatus($completed, OrderStatus::STATUS_FINISHED);
			} catch (Exception $e) {
				Debugger::log('Ceska posta error - ' . $e->getMessage(), 'ordersCheckComplete');
				Debugger::log($e);
			}
		}

		$this->statuses->em->clear();
	}

}
