<?php declare(strict_types = 1);

namespace ComGate\DI;

use ComGate\FrontModule\Model\Comgate;
use ComGate\Model\Gateway\PaymentService;
use Core\DI\CompilerExtension;
use Nette\DI\Definitions\ServiceDefinition;
use Nette\PhpGenerator\ClassType;

class ComgateExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Comgate' => 'ComGate\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();


		$comgateKey = 'comgate.comgate';

		/** @var ServiceDefinition|null $comgate */
		$comgate = $builder->getDefinition($comgateKey);
		if ($comgate) {
			$originalArguments = $comgate->factory->arguments;
			$builder->removeDefinition($comgateKey);
			$builder->addDefinition($comgateKey)
				->setFactory(Comgate::class, [
					$builder->literal('$this->parameters["comgate"]'),
					'@core.sites',
					...$originalArguments,
				])
				->setAutowired(false);
		}

		$paymentServiceKey = 'comgate.gateway.payment';
		/** @var ServiceDefinition|null $paymentService */
		$paymentService    = $builder->getDefinition($paymentServiceKey);
		if ($paymentService) {
			$originalArguments = $paymentService->factory->arguments;
			$builder->removeDefinition($paymentServiceKey);
			$builder->addDefinition($paymentServiceKey)
				->setFactory(PaymentService::class, [
					...$originalArguments,
				])
				->setAutowired(false);
		}
	}

	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('ComGate\Model\ComGateConfig::setParams($this->parameters[\'comgate\']);');
	}
}
