<?php declare(strict_types=1);

namespace ComGate\FrontModule\Components;

use Closure;
use ComGate\FrontModule\Model\ResponseFactory;
use Contributte\Comgate\Entity\Payment;
use Contributte\Comgate\Gateway\PaymentService;
use Contributte\Comgate\Http\Response;
use Core\Model\UI\BaseControl;

class ComgateControl extends BaseControl
{
	/** @var Closure[] */
	public array $onCheckout = [];

	/** @var Closure[] */
	public array $onSuccess = [];

	/** @var Closure[] */
	public array $onError = [];

	protected PaymentService $paymentService;
	protected Payment $payment;

	public function __construct(Payment $payment, PaymentService $paymentService)
	{
		$this->payment = $payment;
		$this->paymentService = $paymentService;
	}

	/**
	 * @throws \Nette\Application\UI\InvalidLinkException
	 * @throws \ReflectionException
	 */
	public function render(array $attrs = [], string $text = 'Pay'): void
	{
		$template = $this->template;
		$template->setFile($this->getTemplateFile());
		$template->add('checkoutLink', $this->link('//checkout!'));
		$template->add('attrs', $attrs);
		$template->add('text', $text);
		$template->render();
	}

	public function handleCheckout(): void
	{
		$res = $this->paymentService->create($this->payment);
		$data = $res->getData();

		if ($res->isOk() && isset($data['redirect'])) {

			$url = $data['redirect'];
			$this->onCheckout($this, $this->payment, $data);

			$presenter = $this->getPresenter();
			$presenter->redirectUrl($url);
		}
	}

	public function errorHandler(\Exception $exception, ?Response $response = null): void
	{
		if (!$this->onError) {
			throw $exception;
		}

		$this->onError($this, $exception, $response);
	}

}
