<?php declare(strict_types = 1);

namespace ComGate\DI;

use ComGate\Http\HttpClient;
use Core\DI\CompilerExtension;
use GuzzleHttp\Client;
use Nette\DI\Definitions\Statement;
use Nette\PhpGenerator\ClassType;

class ComgateExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));

		$builder = $this->getContainerBuilder();

		$config = (array) $this->config;

		$builder->addDefinition($this->prefix('http.client'))
			->setFactory(HttpClient::class, [
				new Statement(Client::class, [
					[
						'base_uri' => $config['parameters']['comgate']['gateway'],
					],
				]),
				$this->prefix('@comgate'),
			]);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Comgate' => 'ComGate\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('ComGate\Model\ComGateConfig::setParams($this->parameters[\'comgate\']);');
	}
}
