<?php declare(strict_types = 1);

namespace ComGate\FrontModule\Model;

use Core\Model\Sites;

class Comgate extends \Contributte\Comgate\Comgate
{
	protected static string $paymentUrl = 'https://payments.comgate.cz/client/instructions/index?id=%s';

	protected Sites $sites;

	protected ?array $config;

	/**
	 * @param mixed $args
	 */
	public function __construct(?array $config, Sites $sites, ...$args)
	{
		$this->config = $config;
		$this->sites  = $sites;

		parent::__construct(...$args);
	}

	public function getMerchant(): string
	{
		$config = $this->getConfig();

		return $config ? $config['merchant'] : parent::getMerchant();
	}

	public function getSecret(): string
	{
		$config = $this->getConfig();

		return $config ? $config['secret'] : parent::getSecret();
	}

	protected function getConfig(): ?array
	{
		$currentSite = $this->sites->getCurrentSite();
		$siteConfig  = $this->config[$currentSite->getIdent()] ?? null;
		$config      = null;

		if ($siteConfig) {
			$config = $siteConfig[$currentSite->getCurrentDomain()->getLang()] ?? $siteConfig;
		}

		return $config;
	}

	public static function getPaymentUrl(string $param): string { return sprintf(self::$paymentUrl, $param); }
}
