<?php declare(strict_types = 1);

namespace ComGate;

use ComGate\Model\ComGateConfig;
use Core\Model\Sites;

class Comgate
{
	protected static string $paymentUrl = 'https://payments.comgate.cz/client/instructions/index?id=%s';

	public function __construct(
		protected Sites $sites,
	)
	{
	}

	public function getMerchant(): string
	{
		$config = $this->getConfig();

		return $config ? $config['merchant'] : ComGateConfig::loadScalar('merchant');
	}

	public function getSecret(): string
	{
		$config = $this->getConfig();

		return $config ? $config['secret'] : ComGateConfig::loadScalar('secret');
	}

	public function isTest(): bool
	{
		$config = $this->getConfig();

		return $config ? $config['test'] : ComGateConfig::loadScalar('test');
	}

	protected function getConfig(): ?array
	{
		$currentSite = $this->sites->getCurrentSite();

		$siteConfig = ComGateConfig::load($currentSite->getIdent());
		$domain     = $currentSite->getCurrentDomain();
		$config     = null;

		if ($siteConfig && $domain) {
			$config = $siteConfig[$domain->getLang()] ?? $siteConfig;
		}

		return $config;
	}

	public static function getPaymentUrl(string $param): string { return sprintf(self::$paymentUrl, $param); }
}
