<?php declare(strict_types = 1);

namespace ComGate\CronModule\Presenters;

use ComGate\Model\Payments;

class DefaultPresenter extends BasePresenter
{
	public function __construct(
		public Payments $payments
	)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionCheckPaidStatus(): void
	{
		$this->payments->checkPaidStatus();
		$this->sendJson(['status' => 'ok']);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

}
