<?php declare(strict_types = 1);

namespace ComGate\DI;

use ComGate\Http\HttpClient;
use Core\DI\CompilerExtension;
use GuzzleHttp\Client;
use Nette\DI\Definitions\Statement;
use Nette\PhpGenerator\ClassType;
use Override;

class ComgateExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));

		$builder = $this->getContainerBuilder();

		$config = (array) $this->config;

		$builder->addDefinition($this->prefix('http.client'))
			->setFactory(HttpClient::class, [
				new Statement(Client::class, [
					[
						'base_uri' => $config['parameters']['comgate']['gateway'],
					],
				]),
				$this->prefix('@comgate'),
			]);
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Comgate' => 'ComGate\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');
		$this->getContainerBuilder();

		$init->addBody('ComGate\Model\ComGateConfig::setParams($this->parameters[\'comgate\']);');
	}
}
