<?php declare(strict_types = 1);

namespace ComGate\FrontModule\Components;

use Closure;
use ComGate\Entity\Payment;
use ComGate\Gateway\PaymentService;
use ComGate\Http\Response;
use Core\Model\UI\BaseControl;
use Exception;
use Nette\Application\UI\InvalidLinkException;
use Nette\Application\UI\Presenter;
use ReflectionException;

class ComgateControl extends BaseControl
{
	/** @var Closure[] */
	public array $onCheckout = [];

	/** @var Closure[] */
	public array $onSuccess = [];

	/** @var Closure[] */
	public array $onError = [];

	public function __construct(
		protected Payment        $payment,
		protected PaymentService $paymentService,
	)
	{
	}

	/**
	 * @throws InvalidLinkException
	 * @throws ReflectionException
	 */
	public function render(array $attrs = [], string $text = 'Pay'): void
	{
		$template = $this->template;
		$template->setFile((string) $this->getTemplateFile());
		$template->add('checkoutLink', $this->link('//checkout!'));
		$template->add('attrs', $attrs);
		$template->add('text', $text);
		$template->render();
	}

	public function handleCheckout(): void
	{
		$res  = $this->paymentService->create($this->payment);
		$data = $res->getData();

		if ($res->isOk() && isset($data['redirect'])) {

			$url = $data['redirect'];

			if (!is_scalar($url)) {
				throw new InvalidLinkException('Redirect URL must be a scalar value.');
			}

			$this->onCheckout($this, $this->payment, $data);

			$presenter = $this->getPresenterIfExists();

			if ($presenter instanceof Presenter) {
				$presenter->redirectUrl((string) $url);
			}
		}
	}

	public function errorHandler(Exception $exception, ?Response $response = null): void
	{
		if (!$this->onError) {
			throw $exception;
		}

		$this->onError($this, $exception, $response);
	}

}
