<?php declare(strict_types = 1);

namespace ComGate\Gateway;

use ComGate\Entity\Payment;
use ComGate\Entity\PaymentStatus;
use ComGate\Entity\RecurringPayment;
use ComGate\Entity\Refund;
use ComGate\Entity\Response\PaymentResponse;
use ComGate\Entity\Response\PaymentStatusResponse;
use ComGate\Entity\Response\RecurringPaymentResponse;
use ComGate\Entity\Response\RefundResponse;
use ComGate\Entity\Response\StornoResponse;
use ComGate\Entity\Storno;
use ComGate\Http\HttpClient;

class PaymentService
{
	public function __construct(
		protected HttpClient $client,
	)
	{
	}

	public function create(Payment $payment): PaymentResponse
	{
		$data = $payment->toArray();

		return new PaymentResponse($this->client->post('create', $data));
	}

	public function recurring(RecurringPayment $payment): RecurringPaymentResponse
	{
		$data = $payment->toArray();

		return new RecurringPaymentResponse($this->client->post('recurring', $data));
	}

	public function status(PaymentStatus $status): PaymentStatusResponse
	{
		return new PaymentStatusResponse($this->client->post('status', $status->toArray()));
	}

	public function refund(Refund $payment): RefundResponse
	{
		$data = $payment->toArray();

		return new RefundResponse($this->client->post('refund', $data));
	}

	public function storno(Storno $payment): StornoResponse
	{
		$data = $payment->toArray();

		return new StornoResponse($this->client->post('cancel', $data));
	}

}
