<?php declare(strict_types = 1);

namespace ContactForms\AdminModule\Components;

use ContactForms\Model\Entities\Form;
use ContactForms\Model\Forms;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class FormForm extends BaseControl
{
	/** @var Form */
	public $form;

	/** @var Forms */
	protected $formsService;

	public function __construct(Forms $forms)
	{
		$this->formsService = $forms;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->form) {
				$eForm        = $this->form;
				$flashMessage = 'contactForms.formForm.edited';
			} else {
				$eForm        = new Form($values->title);
				$flashMessage = 'contactForms.formForm.added';
			}

			$eForm->title       = $values->title;
			$eForm->isPublished = $values->isPublished;

			$this->em->persist($eForm)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setForm($id)
	{
		$this->form = $this->formsService->get($id);

		if ($this->form) {
			$this['form']->setDefaults([
				'title'       => $this->form->title,
				'isPublished' => $this->form->isPublished,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
