<?php declare(strict_types = 1);

namespace ContactForms\Model\Entities;

use ContactForms\Model\Entities\Submission;
use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="contact_forms__form")
 * @ORM\Entity
 */
class Form
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string")
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="from_email", type="string")
	 */
	public $fromEmail;

	/**
	 * @var string
	 * @ORM\Column(name="from_name", type="string")
	 */
	public $fromName;

	/**
	 * @var string
	 * @ORM\Column(name="to_email", type="string")
	 */
	public $toEmail;

	/**
	 * @var string
	 * @ORM\Column(name="to_name", type="string")
	 */
	public $toName;

	/**
	 * @var string
	 * @ORM\Column(name="reply_email", type="string")
	 */
	public $replyEmail;

	/**
	 * @var string
	 * @ORM\Column(name="reply_name", type="string")
	 */
	public $replyName;

	/**
	 * @var string
	 * @ORM\Column(name="subject", type="string")
	 */
	public $subject;

	/**
	 * @var string
	 * @ORM\Column(name="bc", type="string")
	 */
	public $bc;

	/**
	 * @var string
	 * @ORM\Column(name="bcc", type="string")
	 */
	public $bcc;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var Submission[]
	 * @ORM\OneToMany(targetEntity="Submission", mappedBy="form")
	 */
	public $submissions;

	/**
	 * @var array
	 * @ORM\Column(name="fields", type="array", nullable=true)
	 */
	protected $fields;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	protected $params;

	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->submissions = new ArrayCollection();
		$this->params      = [];
		$this->fields      = [];
	}

	/*****
	 * === Params
	 */

	public function getParams() { return $this->params ?: []; }

	public function getParam($key) { return $this->params[$key] ?? null; }

	public function setParam($key, $value)
	{
		if ($value == null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	/*****
	 * === Fields
	 */

	public function getFields() { return $this->fields ?: []; }

	public function getField($key) { return $this->fields[$key] ?? null; }

	public function setField($key, $value)
	{
		if ($value == null) {
			unset($this->fields[$key]);
		} else {
			$this->fields[$key] = $value;
		}
	}
}