<?php declare(strict_types = 1);

namespace ContactForms\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="contact_forms__submission")
 * @ORM\Entity
 */
class Submission
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Form
	 * @ORM\ManyToOne(targetEntity="Form", inversedBy="submissions")
	 * @ORM\JoinColumn(name="form_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $form;

	/**
	 * @var string
	 * @ORM\Column(name="from_email", type="string")
	 */
	public $fromEmail;

	/**
	 * @var string
	 * @ORM\Column(name="from_name", type="string")
	 */
	public $fromName;

	/**
	 * @var string
	 * @ORM\Column(name="to_email", type="string")
	 */
	public $toEmail;

	/**
	 * @var string
	 * @ORM\Column(name="to_name", type="string")
	 */
	public $toName;

	/**
	 * @var string
	 * @ORM\Column(name="reply_email", type="string")
	 */
	public $replyEmail;

	/**
	 * @var string
	 * @ORM\Column(name="reply_name", type="string")
	 */
	public $replyName;

	/**
	 * @var string
	 * @ORM\Column(name="subject", type="string")
	 */
	public $subject;

	/**
	 * @var string
	 * @ORM\Column(name="bc", type="string")
	 */
	public $bc;

	/**
	 * @var string
	 * @ORM\Column(name="bcc", type="string")
	 */
	public $bcc;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	/**
	 * @var array
	 * @ORM\Column(name="values", type="array", nullable=true)
	 */
	protected $values;

	public function __construct($form)
	{
		$this->form   = $form;
		$this->values = [];
	}

	/*****
	 * === Created
	 */

	public function getCreated() { return $this->created; }

	/*****
	 * === Values
	 */

	public function getValues() { return $this->values ?: []; }

	public function getValue($key) { return $this->values[$key] ?? null; }

	public function setValue($key, $value)
	{
		if ($value == null) {
			unset($this->values[$key]);
		} else {
			$this->values[$key] = $value;
		}
	}
}