<?php declare(strict_types = 1);

namespace ContactForms\AdminModule\Components;

use ContactForms\Model\Submissions;
use Core\Model\UI\BaseControl;

class SubmissionsGrid extends BaseControl
{
	/** @var Submissions */
	protected $submissionsService;

	public function __construct(Submissions $submissions)
	{
		$this->submissionsService = $submissions;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDetail()
	{
	}

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->submissionsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->submissionsService->getEr()->createQueryBuilder('g');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('toName', 'contactForms.submissionsGrid.toName', 'detail!');

		// Filter

		// Actions
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype
		$grid->getColumn('isPublished')->getElementPrototype('th')->class[] = 'w1';

		return $grid;
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
}
