<?php declare(strict_types = 1);

namespace ContactForms\AdminModule\Presenters;

use ContactForms\AdminModule\Components\IFormFormFactory;
use ContactForms\AdminModule\Components\IFormsGridFactory;
use ContactForms\AdminModule\Components\ISubmissionsGridFactory;
use ContactForms\Model\Entities\Form;
use Nette\Http\IResponse;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('contactForms.title.contactForms'));
		$this->setHeader('contactForms.title.contactForms');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'contactForms.menu.addForm',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddForm()
	{
		$this->setTitle($this->translator->translate('contactForms.title.addForm'));
		$this->setHeader('contactForms.title.addForm');
	}

	public function actionEditForm($id)
	{
		$form = $this->em->getRepository(Form::class)->find($id);

		if (!$form)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('contactForms.title.editForm'), $form->title);
		$this->setHeader('contactForms.title.editForm');

	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentFormsGrid(IFormsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentFOrmForm(IFormFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setForm($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentSubmissionsGrid(ISubmissionsGridFactory $factory)
	{
		return $factory->create();
	}
}