CKEDITOR.plugins.add('readmore', {
	requires: 'widget',

	init: function (editor) {
		var pluginName = 'ReadMore';
		var htmlCode = '<div class="ck-readmore" data-type="' + editor.lang.readmore.readmore + '"><p></p></div>';

		editor.widgets.add('readmore', {
			requiredContent: 'div(ck-readmore)',
			template: htmlCode,
			button: 'ReadMore',
			editables: {
				content: {
					selector: '.ck-readmore'
				},
			},
			upcast: function (element) {
				return element.name == 'div' && element.hasClass('ck-readmore');
			}
		});
		editor.addCommand('insertReadMore', {
			exec: function (editor, data) {
				editor.insertHtml(htmlCode);
			}
		});
		editor.ui.addButton('ReadMore', {
			label: editor.lang.readmore.readmore,
			command: 'insertReadMore',
			toolbar: 'editor'
		});
	}
});
