<?php

require_once __DIR__ . '/../init.php';

use Leafo\ScssPhp\Compiler;

$robotLoader = (new \Nette\Loaders\RobotLoader())
	->addDirectory(LIBS_DIR . '/leafo/scssphp/')
	->addDirectory(LIBS_DIR . '/matthiasmullie/minify/')
	->setTempDirectory(TMP_DIR)
	->register();

$fromConsole = isset($output);

if (!$fromConsole)
	$output = new \Kdyby\Console\StringOutput();

$output->writeLn('<info>--- Kompilace scss adminu ---</info>');
$assetsDir = CMS_DIR . '/www/assets';

try {
	$scss = new Compiler();
	$scss->setImportPaths($assetsDir . '/admin/default/scss/');
	@unlink($assetsDir . '/admin/_css/default.css');
	file_put_contents($assetsDir . '/admin/_css/default.css', $scss->compile('@import "template.scss";'));
	$output->writeLn('<info>[OK] - default - zkompilováno</info>');
} catch (\Exception $e) {
	$output->writeln('<error>[ERROR] - default - ' . $e->getMessage() . '</error>');
}

try {
	$scss = new Compiler();
	$scss->setImportPaths($assetsDir . '/admin/login/scss/');
	@unlink($assetsDir . '/admin/_css/login.css');
	file_put_contents($assetsDir . '/admin/_css/login.css', $scss->compile('@import "template.scss";'));
	$output->writeLn('<info>[OK] - login - zkompilováno</info>');
} catch (\Exception $e) {
	$output->writeln('<error>[ERROR] - login - ' . $e->getMessage() . '</error>');
}

if (!$fromConsole)
	echo $output->getOutput();