<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

abstract class SecuredPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
	}

	public function checkRequirements($element)
	{
		if (!$this->getUser()->isLoggedIn())
			$this->forward(':Users:Admin:Login:');

		$hasAccess = false;
		foreach ($this->getUser()->getRoles() as $role) {
			if (in_array($role, $this->systemConfig->get('adminRoles'))) {
				$hasAccess = true;
				break;
			}
		}

		if (!$hasAccess) {
			$this->getUser()->logout(true);
			$this->forward(':Users:Admin:Login:');
		}

		parent::checkRequirements($element);
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout()
	{
		$this->getUser()->logout(true);
		$this->redirect(':Users:Admin:Login:');
	}
}
