<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="core__setting")
 * @ORM\Entity
 */
class Setting
{
	use MagicAccessors;

	/**
	 * @var string
	 *
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public $key;

	/**
	 * @var string
	 * @ORM\Column(name="`value`", type="text", nullable=true)
	 */
	public $value;

	/**
	 * Setting constructor.
	 *
	 * @param string $key
	 * @param string $value
	 */
	public function __construct(string $key, string $value)
	{
		$this->key   = $key;
		$this->value = $value;
	}
}
