<?php declare(strict_types = 1);

namespace Core\Model\Images\Macros;

use Nette;

class Helpers
{
	use Nette\SmartObject;

	public static function prepareMacroArguments($macro)
	{
		$arguments = array_map(function($value) {
			return trim($value);
		}, explode(",", $macro));

		$namespace = null;
		$name      = $arguments[0];
		$size      = (isset($arguments[1]) AND !empty($arguments[1])) ? $arguments[1] : null;
		$flags     = (isset($arguments[2]) AND !empty($arguments[2])) ? $arguments[2] : null;
		$watermark = (isset($arguments[3]) AND !empty($arguments[3])) ? $arguments[3] : null;

		if (count($ns = explode("/", $name)) >= 2) {
			$name      = array_pop($ns);
			$namespace = implode("/", $ns);
		}

		return [
			"namespace" => $namespace,
			"name"      => $name,
			"size"      => $size,
			"flags"     => $flags,
			"watermark" => $watermark,
		];
	}

	/**
	 * @param int $originalWidth
	 * @param int $originalHeight
	 * @param int $newWidth
	 *
	 * @return array
	 */
	public static function calculateNewSize(int $originalWidth, int $originalHeight, int $newWidth)
	{
		if ($originalHeight === 0) {
			$newHeight = 0;
		} else {
			$ratio = $originalWidth / $originalHeight;
		}

		return [
			'width'  => $newWidth,
			'height' => isset($newHeight) ? $newHeight : ceil($newWidth / $ratio),
		];
	}

}
