<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\Utils\Html;

/**
 * Trait TTextBase
 * @package Core\Model\UI\Form\Traits
 */
trait TTextBase
{
	/**
	 * @return Html
	 */
	public function getControl()
	{
		$control          = parent::getControl();
		$control->class[] = 'form-control form-control-lg';
		if (!empty($this->placeholder)) {
			$control->setAttribute('placeholder', $this->placeholder);
		}

		return $this->createTranslatableControl($control);
	}

	/**
	 * Sets control's value.
	 * @return static
	 * @internal
	 */
	public function setValue($value)
	{
		if ($value === null) {
			$value = '';
		} elseif (!$this->getIsMultiLanguage() && !is_scalar($value) && !method_exists($value, '__toString')) {
			throw new Nette\InvalidArgumentException(sprintf("Value must be scalar or null, %s given in field '%s'.", gettype($value), $this->name));
		}
		$this->value    = $value;
		$this->rawValue = $this->getIsMultiLanguage() ? (array) $value : (string) $value;

		return $this;
	}
}
