<?php declare(strict_types = 1);

namespace Core\Console\Assets;

use Doctrine;
use MatthiasMullie\Minify;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class AdminCssMinify extends AbstractCommand
{
	protected function configure()
	{
		$this->setName('assets:admin-css:minify')->setDescription('Minifakce css adminu');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeLn('<info>--- Minifikace css adminu ---</info>');
		$assetsDir = $_SERVER['PSHKCMS_PATH'] . '/www/assets';

		try {
			$minifier = new Minify\CSS($assetsDir . '/admin/_css/default.css');
			$minifier->minify($assetsDir . '/admin/_css/default.min.css');
			$output->writeLn('<info>[OK] - default - minifikováno</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - default - ' . $e->getMessage() . '</error>');
		}

		try {
			$minifier = new Minify\CSS($assetsDir . '/admin/_css/login.css');
			$minifier->minify($assetsDir . '/admin/_css/login.min.css');
			$output->writeLn('<info>[OK] - login - minifikováno</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - login - ' . $e->getMessage() . '</error>');
		}
	}
}