<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Core\Model\Entities\ExtraField;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Mapping as ORM;

trait TExtraField
{
	/**
	 * @var ExtraField[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="Core\Model\Entities\ExtraField", mappedBy="sectionKey", indexBy="key")
	 */
	protected $extraFields;

	public function fillExtraField(ExtraField &$extraField): void
	{
		$extraField->sectionKey  = $this->getId();
		$extraField->sectionName = self::EXTRA_FIELD_SECTION;
	}

	/**
	 * @return ArrayCollection
	 */
	public function getExtraFields()
	{
		$criteria = Criteria::create()
			->where(Criteria::expr()->eq('sectionName', self::EXTRA_FIELD_SECTION));

		return $this->extraFields->matching($criteria);
	}

	/**
	 * @return ExtraField[]
	 */
	public function getExtraFieldsByKey(): array
	{
		$result = [];

		foreach ($this->getExtraFields()->toArray() as $v)
			$result[$v->key] = $v;

		return $result;
	}

	public function getExtraFieldsValues(): array
	{
		$result = [];

		foreach ($this->getExtraFields()->toArray() as $v)
			$result[$v->key] = $v->value;

		return $result;
	}
}
