import PNotify from 'pnotify/dist/es/PNotify';

export class Flashes {
	constructor(naja) {
		let snippetFlashes = document.getElementById('snippet--flashes');
		if (snippetFlashes.firstChild) {
			this.pushNotifyFromSnippet(snippetFlashes.innerHTML);
		}

		naja.snippetHandler.addEventListener('afterUpdate', e => {
			if (e.snippet.id === 'snippet--flashes') {
				try {
					this.pushNotifyFromSnippet(e.content);

					e.preventDefault();
				} catch (e) {
				}
			}
		});
	}

	pushNotifyFromSnippet(content) {
		let el = document.createElement('div');
		el.innerHTML = content;

		for (let i in el.children) {
			let child = el.children[i];

			if (!child.dataset || !child.dataset.type)
				return true;

			this.pushNotifyFromHtmlEl(child);
		}
	}

	pushNotifyFromHtmlEl(el) {
		let type = el.dataset.type;

		if (type == 'danger' || type == 'warning')
			type = 'error';

		PNotify.alert({
			text: el.innerHTML,
			textTrusted: true,
			type: type,
		});
	}
}
