<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\IDataFormFactory;

class SettingsPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.cmsSettings', 'fas fa-cogs');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentGlobalDataForm(IDataFormFactory $factory)
	{
		return $factory->create('globalData');
	}
}
