<?php declare(strict_types=1);

namespace Core\Model\Helpers;

use \Nette\Utils\Strings as NetteStrings;

class Strings extends NetteStrings
{
	/**
	 * @param float $price
	 * @param string|null      $currency
	 * @param string|null      $separator
	 * @param bool             $currencyFromLeft
	 * @param string|null      $decSep
	 * @param int|null         $decimals
	 * @return string
	 */
	public static function priceFormat(float $price, ?string $currency = 'Kč', ?string $separator = ' ', bool $currencyFromLeft = false, ?string $decSep = ',', ?int $decimals = 2): string
	{
		$decPoint = $decSep;
		$priceFormatted = number_format($price, $decimals, $decPoint, ' ');

		// e.g.: ,00
		$tail = $decPoint . implode('', array_fill(0, $decimals, 0));

		if (NetteStrings::endsWith($priceFormatted, $tail)) {
			$priceFormatted = substr($priceFormatted, 0, strlen($priceFormatted)-strlen($tail));
		}

		return sprintf(
			'%s%s%s',
			$currencyFromLeft ? $currency : $priceFormatted,
			$separator ?? ' ',
			$currencyFromLeft ? $priceFormatted : $currency
		);
	}
}