<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Core\Model\UI\Form\Controls;

/**
 * @method addFilesManager($name, $caption)
 * @method Controls\EditorInput addEditor($name, $caption)
 * @method Controls\LangsSelectInput addLangsSelect($name, $caption)
 * @method Controls\GalleryPopupInput addGalleryPopup($name, $caption)
 *
 * Trait BaseContainerTrait
 * @package Core\Model\UI\Form\Traits
 */
trait BaseContainerTrait
{
	public function addBool($name, $label = null, array $items = [])
	{
		$comp = new Controls\BoolInput($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addDateTimePicker($name, $label = null)
	{
		$comp = new Controls\DateTimePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addDatePicker($name, $label = null)
	{
		$comp = new Controls\DatePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addTags($name, $label = null, $callback, $createCallback)
	{
		$comp = new Controls\TagsInput($label, $callback, $createCallback);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addSortableCheckboxList($name, $label = null, $items = [])
	{
		$comp = new Controls\SortableCheckboxList($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string      $name
	 * @param string|null $saveCaption
	 * @param string|null $saveAndCloseCaption
	 * @param string|null $cancelCaption
	 *
	 * @return Controls\SaveCancelControl
	 */
	public function addSaveCancelControl($name = 'saveControl', $saveCaption = null, $saveAndCloseCaption = null, $cancelCaption = null)
	{
		$comp = new Controls\SaveCancelControl($saveCaption, $saveAndCloseCaption, $cancelCaption);
		$this->addComponent($comp, $name);

		return $comp;
	}
}
