<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Entities\Redirect;
use Core\Model\Helpers\BaseEntityService;

/**
 * Class Redirects
 * @package Core\AdminModule\Model
 *
 * @method Redirect|object|null getReference($id)
 * @method Redirect[]|null getAll()
 * @method Redirect|null get($id)
 */
class Redirects extends BaseEntityService
{
	protected $entityClass = Redirect::class;

	public function findOneBy($criteria)
	{
		$redirect = $this->getEr()->findOneBy($criteria);

		if ($redirect) {
			$redirect->views++;
			$this->em->persist($redirect);
			$this->em->flush();
		}

		return $redirect;
	}
}
