<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Settings;
use Nette\Utils\FileSystem;
use ScssPhp\ScssPhp\Compiler;

class ColorsCompiler
{
	/** @var Settings */
	protected $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	public function compile(): bool
	{
		$vars = $this->settings->getPrefixed('webColors');

		$scss = new Compiler();

		$scss->setVariables($vars);
		$scss->setImportPaths(SRC_DIR . '/core/assets/front/src/globalScss/');

		$oldFile = ASSETS_DIR . '/front/dist/webColorsOld.css';
		$newFile = ASSETS_DIR . '/front/dist/webColors.css';
		$tmpFile = TMP_DIR . '/webColors.tmp';

		try {
			file_put_contents($tmpFile, $scss->compile('@import "settings.scss";'));
			if (file_exists($newFile))
				FileSystem::rename($newFile, $oldFile);
			FileSystem::rename($tmpFile, $newFile);
			FileSystem::delete($tmpFile);
			FileSystem::delete(TMP_DIR . '/cache/latte');
		} catch (\Exception $e) {
			bdump($e->getMessage());

			return false;
		}

		return true;
	}
}
