<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Contributte\Application\LinkGenerator;
use Core\Model\Images\ImagePipe;
use Core\Model\Lang\Langs;
use Core\Model\Settings;
use Nette;
use Nette\Application\UI;
use Nette\Bridges\ApplicationLatte\ILatteFactory;
use Nette\Caching\IStorage;
use Nette\Http\IRequest;
use Nette\Security\User;
use Nette\Utils\Html;
use Nette\Localization\ITranslator;

final class TemplateFactory extends Nette\Bridges\ApplicationLatte\TemplateFactory
{
	/** @var array */
	protected $support;

	/** @var ImagePipe */
	protected $imagePipe;

	/** @var LinkGenerator */
	protected $linkGenerator;

	/** @var Langs */
	protected $langs;

	/** @var Settings */
	protected $settings;

	/** @var ITranslator */
	protected $translator;

	public function __construct($support, ILatteFactory $latteFactory, ITranslator $translator, IRequest $httpRequest = null, User $user = null, IStorage $cacheStorage = null, $templateClass = null, ImagePipe $imagePipe, LinkGenerator $linkGenerator, Settings $settings, Langs $langs)
	{
		parent::__construct($latteFactory, $httpRequest, $user, $cacheStorage, $templateClass);
		$this->support       = $support;
		$this->imagePipe     = $imagePipe;
		$this->linkGenerator = $linkGenerator;
		$this->langs         = $langs;
		$this->settings      = $settings;
		$this->translator    = $translator;
	}

	public function createTemplate(UI\Control $control = null)
	{
		$template = parent::createTemplate($control);

		$template->_imagePipe    = $this->imagePipe;
		$template->linkGenerator = $this->linkGenerator;
		$template->support       = $this->support;
		$template->siteName      = $this->settings->get('siteName');
		$template->adminAssets   = '/' . ASSETS_FOLDER . '/admin';
		$template->frontAssets   = '/' . ASSETS_FOLDER . '/front';
		$template->frontImages   = $template->frontAssets . '/img';
		$template->webSettings   = $this->settings->getAll();
		$template->langs         = $this->langs;
		$template->lang          = $this->translator->getLocale();
		$year                    = date('Y');
		$template->pshkCopyright = '<div id="pshk-copyright">&copy; by <a href="https://www.pshk.cz" target="_blank">PSHK s.r.o.</a></div>';

		return $template;
	}
}
