<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Core\Model\Helpers\Strings;
use Ublaboo;
use Ublaboo\DataGrid\DataGrid;
use Ublaboo\DataGrid\Row;

class ColumnPrice extends Ublaboo\DataGrid\Column\ColumnText
{
	/** @var bool */
	protected $currencyFromLeft = false;

	/** @var string|null */
	protected $separator = ' ';

	/** @var string|null */
	protected $currency = 'Kč';

	/** @var string|null */
	protected $decSep = ',';

	/** @var int|null */
	protected $decimals = 2;

	public function __construct(DataGrid $grid, string $key, string $column, string $name)
	{
		parent::__construct($grid, $key, $column, $name);

		$this->setAlign('right');
	}

	public function render(Row $row)
	{
		$value = parent::render($row);

		return $value
			? Strings::priceFormat((float) $value, $this->currency, $this->separator, $this->currencyFromLeft, $this->decSep, $this->decimals)
			: '';
	}

	public function setCurrencyFromLeft(bool $value = false): self
	{
		$this->currencyFromLeft = $value;

		return $this;
	}

	public function setSeparator(?string $value = null): self
	{
		$this->separator = $value;

		return $this;
	}

	public function setCurrency(?string $value = null): self
	{
		$this->currency = $value;

		return $this;
	}

	public function setDecSep(?string $decSep = null): self
	{
		$this->decSep = $decSep;

		return $this;
	}

	public function setDecimals(?int $decimals = null): self
	{
		$this->decimals = $decimals;

		return $this;
	}
}
