<?php declare(strict_types = 1);

namespace Core\Console\Assets;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Leafo\ScssPhp\Compiler;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class AdminScssCompile extends AbstractCommand
{
	protected function configure()
	{
		$this->setName('assets:admin-scss:compile')->setDescription('Zkompilovat scss adminu');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeLn('<info>--- Kompilace scss adminu ---</info>');
		$assetsDir = $_SERVER['PSHKCMS_PATH'] . '/www/assets';

		try {
			$scss = new Compiler();
			$scss->setImportPaths($assetsDir . '/admin/default/scss/');
			@unlink($assetsDir . '/admin/_css/default.css');
			file_put_contents($assetsDir . '/admin/_css/default.css', $scss->compile('@import "template.scss";'));
			$output->writeLn('<info>[OK] - default - zkompilováno</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - default - ' . $e->getMessage() . '</error>');
		}

		try {
			$scss = new Compiler();
			$scss->setImportPaths($assetsDir . '/admin/login/scss/');
			@unlink($assetsDir . '/admin/_css/login.css');
			file_put_contents($assetsDir . '/admin/_css/login.css', $scss->compile('@import "template.scss";'));
			$output->writeLn('<info>[OK] - login - zkompilováno</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - login - ' . $e->getMessage() . '</error>');
		}
	}
}