<?php declare(strict_types = 1);

namespace Core\Console\Seo;

use Contributte\Application\LinkGenerator;
use Core\FrontModule\Model\SiteMap;
use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Kdyby;
use Nette\Http\Request;
use Nette\Utils\FileSystem;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Thepixeldeveloper\Sitemap\Drivers\XmlWriterDriver;
use Tracy\Debugger;

/**
 * Class GenerateSiteMap
 * @package Core\Console\Seo
 */
class GenerateSiteMap extends AbstractCommand
{
	/** @var SiteMap @inject */
	public $siteMap;

	/** @var Request @inject */
	public $httpRequest;

	/** @var Langs @inject */
	public $langs;

	protected function configure()
	{
		$this->setName('seo:generate-sitemap')->setDescription('Generate sitemaps');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('GENERATE SITEMAP.XML');

		try {
			set_time_limit(600);
			Debugger::dispatch();
			$groups = ['default'];

			$created = [];
			$exist   = glob(WWW_DIR . '/sitemap*.xml');

			FileSystem::delete(SiteMap::TMP_DIR);

			foreach ($this->langs->getLangs(false) as $lang) {
				$lang = $lang->getTag();
				foreach ($groups as $group) {
					$sitemap = $this->siteMap->getSiteMap($lang, $group);

					if (!$sitemap)
						continue;

					$driver = new XmlWriterDriver();
					$sitemap->accept($driver);

					$filename = "sitemap-$group-$lang.xml";

					$filePath  = WWW_DIR . '/' . $filename;
					$created[] = $filePath;
					file_put_contents($filePath, $driver->output());

					if (isset($sitemap->all()[0]) && $sitemap->all()[0] instanceof \Thepixeldeveloper\Sitemap\Sitemap) {
						foreach ($sitemap->all() as $k => $v) {
							$tmp = $this->siteMap->getSiteMap($lang, $group, $k + 1);

							if (!$tmp)
								continue;

							$driver = new XmlWriterDriver();
							$tmp->accept($driver);

							$filePath  = WWW_DIR . '/' . basename($v->getLoc());
							$created[] = $filePath;
							file_put_contents($filePath, $driver->output());
							$tmp = null;
						}
					}
					$sitemap = null;
				}
			}

			foreach (array_diff($exist, $created) as $f) {
				@unlink($f);
			}

			$robotsTxtContent = @file_get_contents(WWW_DIR . '/robots.txt');
			if (strpos($robotsTxtContent, 'Sitemap:') === false) {
				$content = '';
				foreach ($groups as $group) {
					foreach ($this->langs->getLangs(false) as $lang) {
						$lang    = $lang->getTag();
						$content .= "Sitemap: " . $this->httpRequest->getUrl()->absoluteUrl . "sitemap-$group-$lang.xml \n";
					}
				}

				$robotsTxt = fopen(WWW_DIR . '/robots.txt', "a");
				fwrite($robotsTxt, $content);
				fclose($robotsTxt);
			}

			$output->writeLn('<info>[OK] - sitemaps created</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}
	}
}
