<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	/** @var RouteHelper */
	protected $routeHelper;

	public function __construct(RouteHelper $routeHelper)
	{
		$this->routeHelper = $routeHelper;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$admin   = new RouteListAdmin;
		$admin[] = $this->routeHelper->createAdminRoute('/admin/<module>/<presenter>[/<action>[/<id>]]', [
			'module'    => 'Dashboard:Admin',
			'presenter' => 'Default',
			'action'    => 'default',
			'id'        => null,
		]);

		$router[] = $admin;

		$router[] = $cron = new RouteListAdmin;
		$cron[]   = $this->routeHelper->createAdminRoute('/cron/<module>/<presenter>[/<action>[/<id>]]', [
			'module'    => 'Dashboard:Cron',
			'presenter' => 'Default',
			'action'    => 'default'])->setModule('Cron');

		$router[] = $admin = new RouteList('Core:Admin');
		foreach (['filesmanager' => 'FilesManager'] as $url => $presenter) {
			$admin[] = $this->routeHelper->createAdminRoute('/admin/' . $url . '/<action>[/<id>]', [
				'presenter' => $presenter,
				'action'    => 'default',
				'id'        => null,
			]);
		}

		return $router;
	}
}
