<?php declare(strict_types = 1);

namespace Core\Model;

use Core\Model\Entities\Country;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query;

/**
 * Class Countries
 * @package Core\Model
 *
 * @method Country|object|null getReference($id)
 * @method Country|null get($id)
 */
class Countries extends BaseEntityService
{
	/** @var string */
	protected $entityClass = Country::class;
	
	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	/** @return Country[]|null */
	public function getAll()
	{
		$countriesQuery = $this->getEr()->createQueryBuilder('c', 'c.id');
		$countriesQuery->orderBy('c.position');
		$countries = $countriesQuery->getQuery()->getResult();
		
		return $countries;
	}
	
	public function getAllNameColumn()
	{
		$countries = $this->getAll();
		//alternativne https://gist.github.com/ostrolucky/f9f1e0b271357573fde55b7a2ba91a32
		$countryOptions = [];
		foreach ($countries as $key => $country) {
			$countryOptions[$key] = $country->getName();
		}
		
		return $countryOptions;
	}
}
