import SimpleBar from 'simplebar';
import naja from "naja";
import {Utilities} from "core/front/src/js/utils/utilities";
import addStylesToShadowDOM from "vue-style-loader/lib/addStylesShadow";
import Pickr from "@simonwep/pickr";

naja.historyHandler.uiCache = false;
naja.history = false;
naja.uiHandler.selector = '';
window.naja = naja;
global.naja = window.naja;

// Kousky CK editoru před kompletní změnou
document.ckEditorExtraPlugins = 'panelbutton,button,floatpanel,panel,justify,colorbutton,font,filemanager,lineheight,readmore,wordcount';

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

global.naja.addEventListener('before', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay !== null) {
		loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
	} else {
		document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
			'<div class="spinner">' +
			'<div class="rect1"></div>' +
			'<div class="rect2"></div>' +
			'<div class="rect3"></div>' +
			'<div class="rect4"></div>' +
			'<div class="rect5"></div>' +
			'</div></div>');
	}
});

global.naja.addEventListener('complete', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay) {
		if (loadingOverlay.dataset.count > 1)
			loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
		else
			loadingOverlay.parentNode.removeChild(loadingOverlay);
	}
});

document.addEventListener('DOMContentLoaded', () => {
	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});

	initBoolSwitcherControl();
	initNestedList();
	initDataTextToggle();
	initDataGridNestedListChange();
	initColorPicker();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		initBoolSwitcherControl();
		initNestedList();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
	});

	global.naja.addEventListener('complete', e => {
		initBoolSwitcherControl();
		initNestedList();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
	});
});

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

// Nested list
const initNestedList = () => {
	document.querySelectorAll('.nested-list:not(.init)').forEach(list => {
		list.classList.add('init');

		list.querySelectorAll('.nested-list__arrow').forEach(arrow => {
			arrow.addEventListener('click', e => {
				arrow.parentNode.parentNode.classList.toggle('active');
			});
		});

		list.querySelectorAll('input:checked').forEach(input => {
			let item = input.parentNode.parentNode.parentNode;
			let i = 0;

			while (item && !item.classList.contains('active') && item.classList.contains('nested-list__item') && i < 20) {
				item.classList.add('active');

				item = item.parentNode.parentNode;
				i++;
			}
		});
	});
};

const initDataTextToggle = () => {
	document.querySelectorAll('[data-text-toggle]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			let tmp = el.textContent.trim();

			el.textContent = el.dataset.textToggle.trim();
			el.dataset.textToggle = tmp;
		});
	});
};

const initDataGridNestedListChange = () => {
	document.querySelectorAll('.datagrid .nested-list input:not(.init)').forEach(input => {
		input.classList.add('init');

		input.addEventListener('change', e => {
			global.naja.uiHandler.submitForm(input.form);
		});
	});
};

// Init color pickeru
const initColorPicker = () => {
	document.querySelectorAll('[data-color-input="wrap"]:not(.init)').forEach(wrap => {
		wrap.classList.add('init');
		let input = wrap.querySelector('[data-color-input="input"]');

		let pickr = Pickr.create({
			el: wrap.querySelector('[data-color-input="btn"]'),
			theme: 'classic',
			default: input.value || '#2AABE2',
			swatches: [
				'#4c99ca',
				'#f5b252',
				'#30e4ef',
				'#4c4949',
				'#ff0000',
				'#f6f6f6',
				'#a1a1a1',
				'#cacaca',
				'#464444',
				'#39b54a',
				'#dadee0',
				'#8f8b8b',
			],
			components: {
				preview: true,
				opacity: true,
				hue: true,
				interaction: {
					hex: true,
					rgba: true,
					hsla: true,
					hsva: false,
					cmyk: false,
					input: true,
					clear: true,
					save: true
				}
			},
			strings: {
				save: wrap.dataset.colorPickerTextSave,
				clear: wrap.dataset.colorPickerTextClear,
			}
		}).on('save', (color, instance) => {
			input.value = color ? color.toHEXA().toString() : '';
			instance.hide();
		});

		input.addEventListener('focus', e => {
			input.blur();
			pickr.show();
			setTimeout(() => {
				pickr.getRoot().interaction.result.focus();
			}, 200);
		});
	});
};
