<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\ITemplate;
use Nette\Utils\ArrayHash;
use Symfony\Component\EventDispatcher\Event;

class FormValidateEvent extends Event
{
	/** @var BaseForm */
	public $form;

	/** @var ArrayHash */
	public $values;

	/** @var ITemplate */
	public $template;

	/** @var AbstractPresenter */
	public $presenter;

	/** @var array */
	public $custom;

	public function __construct(BaseForm $form, ArrayHash $values, ?ITemplate $template, ?AbstractPresenter $presenter)
	{
		$this->form      = $form;
		$this->values    = $values;
		$this->template  = $template;
		$this->presenter = $presenter;
	}
}
