<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

use Nette\Utils\Json;
use Core\Model\TemplateReader\TemplateTextTypesCollection;

class TemplateText
{
	/** @var \Core\Model\TemplateReader\TemplateTextTypesCollection */
	protected $templateTextTypes;

	public function __construct(TemplateTextTypesCollection $templateTextTypesCollection)
	{
		$this->templateTextTypes = $templateTextTypesCollection;
	}

	public function render($type, $value = null, $params = [])
	{
		$item = $this->templateTextTypes->getItemByType($type);

		if ($item) {
			$item->setDefault($value);

			if (is_string($params))
				$params = Json::decode($params, Json::FORCE_ARRAY);

			return $item->render($params);
		}

		return '';
	}
}
