<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Filter;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\Controls\RadioNestedInput;
use Ublaboo\DataGrid\Filter\Filter;
use Nette;

class FilterRadioNestedList extends Filter
{
	/** @var string */
	protected $template = 'datagrid_filter_radio_nested_list.latte';

	/** @var string */
	protected $type = 'radioNestedList';

	/** @var array */
	protected $flatItems = [];

	public function __construct($grid, $key, $name, array $flatItems, $column)
	{
		parent::__construct($grid, $key, $name, $column);

		$this->flatItems = $flatItems;
	}

	public function addToFormContainer(BaseContainer $container)
	{
		$control = $container->addRadioNestedList($this->key, $this->name, $this->flatItems);
		$control->setViewType(RadioNestedInput::VIEW_TYPE_COMPACT);

		$this->addAttributes($container[$this->key]);
	}

	protected function addAttributes($input)
	{
		if ($this->grid->hasAutoSubmit()) {
			$input->setAttribute('data-autosubmit', true);
		} else {
			$input->setAttribute('data-datagrid-manualsubmit', true);
		}

		foreach ($this->attributes as $key => $value) {
			if (is_array($value)) {
				$value = array_unique($value);
				$value = implode(' ', $value);
			}

			$input->setAttribute($key, $value);
		}

		return $input;
	}


}
