<?php declare(strict_types = 1);

namespace Core\Model\UI\Form;

use Core\Model\UI\Form\Traits\BaseContainerTrait;
use Core\Model\UI\Form\Traits\BootstrapContainerTrait;
use Nette\Forms\Container;

class BaseContainer extends Container
{
	use BootstrapContainerTrait;
	use BaseContainerTrait;

	/** @var array */
	protected $customData = [];

	public function addCustomData(string $key, $value): self
	{
		$this->customData[$key] = $value;

		return $this;
	}

	public function getCustomData(string $key) { return $this->customData[$key] ?? null; }
}
