<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Core\FrontModule\Model\Redirects;
use Nette;

/**
 * Class Error4xxPresenter
 * @package Core\ErrorModule\Presenters
 */
class Error4xxPresenter extends BasePresenter
{

	/** @var Redirects @inject */
	public $redirectsService;

	public function startup()
	{
		parent::startup();

		$r = $this->redirectsService->getEr()->createQueryBuilder('r')->select('r.to, r.redirectCode')
			->where('r.from = :from')->andWhere('r.to IS NOT NULL')
			->setParameters(['from' => ltrim($this->getHttpRequest()->getUrl()->getPath(), '/')])
			->getQuery()->getOneOrNullResult();

		if ($r) {
			if (strpos($r['to'], ':') === 0) {
				$tmp       = explode(' ', $r['to']);
				$presenter = array_shift($tmp);
				foreach ($tmp as $k => $v) {
					if (is_numeric($v))
						$tmp[$k] = (int) $v;
				}

				$this->redirect($presenter, $tmp);
			} else {
				$this->redirectUrl($r['to'], $r['redirectCode']);
			}
		}

		if (!$this->getRequest()->isMethod(Nette\Application\Request::FORWARD)) {
			$this->error();
		}
	}
}
