<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\Settings;

class SeoParser
{
	/** @var Settings */
	protected $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	/**
	 * @param string $string
	 *
	 * @return string
	 */
	public function parse(string $string): string
	{
		$string = str_replace(
			['$siteName', '$separator'],
			[$this->settings->get('siteName'), $this->settings->get('siteNameSeparator')],
			$string
		);
		$string = trim($string);

		return $string;
	}
}
