<?php declare(strict_types=1);

namespace Core\Model\Lang;

/**
 * Class Lang
 * @package Core\Model\Lang
 */
class Lang implements ILang
{
	/** @var string */
	protected $title;

	/** @var string */
	protected $shortTitle;

	/** @var string */
	protected $tag;

	/** @var string */
	protected $fullTag;

	public function __construct(string $title, string $shortTitle, string $tag, string $fullTag)
	{
		$this->title      = $title;
		$this->shortTitle = $shortTitle;
		$this->tag        = $tag;
		$this->fullTag    = $fullTag;
	}

	public function getTitle(): string { return $this->title; }

	public function getShortTitle(): string { return $this->shortTitle; }

	public function getTag(): string { return $this->tag; }

	public function getFullTag(): string { return $this->fullTag; }
}
