<?php declare(strict_types=1);

namespace Core\Model\Templating\Filters;

use Core\Model\Helpers\Strings;
use Core\Model\SystemConfig;

class Price
{
	/** @var bool */
	protected $currencyFromLeft = false;

	/** @var string|null */
	protected $separator;

	/** @var string|null */
	protected $currency;

	/** @var string|null */
	protected $decSep;

	/** @var int|null */
	protected $decimals;

	/**
	 * Price constructor.
	 */
	public function __construct() {
		$config = SystemConfig::load('priceFilter');
		$this->setCurrency($config['currency']);
		$this->setSeparator($config['separator']);
		$this->setCurrencyFromLeft($config['currencyFromLeft']);
		$this->setDecimals($config['decimals']);
		$this->setDecSep($config['decSep']);
	}

	/**
	 * @param float       $price
	 * @param string|null $currency
	 * @param bool|null   $currencyFromLeft
	 * @param string|null $separator
	 * @param string|null $decSep
	 * @param int|null    $decimals
	 * @return string
	 */
	public function __invoke(float $price, ?string $currency = null, ?bool $currencyFromLeft = null, ?string $separator = null, ?string $decSep = null, ?int $decimals = null): string
	{
		return $this->format($price, $currency, $currencyFromLeft, $separator, $decSep, $decimals);
	}

	/**
	 * @param float       $price
	 * @param string|null $currency
	 * @param bool|null   $currencyFromLeft
	 * @param string|null $separator
	 * @param string|null $decSep
	 * @param int|null    $decimals
	 * @return string
	 */
	public function format(float $price, ?string $currency = null, ?bool $currencyFromLeft = null, ?string $separator = null, ?string $decSep = null, ?int $decimals = null): string
	{
		$currency = $currency ?? $this->currency;
		$currencyFromLeft = $currencyFromLeft ?? $this->currencyFromLeft;
		$separator = $separator ?? $this->separator;
		$decSep = $decSep ?? $this->decSep;
		$decimals = $decimals ?? $this->decimals;
		return Strings::priceFormat($price, $currency, $separator, $currencyFromLeft, $decSep, $decimals);
	}

	/**
	 * @param bool $value
	 */
	public function setCurrencyFromLeft(bool $value = false): void
	{
		$this->currencyFromLeft = $value;
	}

	/**
	 * @param string|null $value
	 */
	public function setSeparator(?string $value = null): void
	{
		$this->separator = $value;
	}

	/**
	 * @param string|null $value
	 */
	public function setCurrency(?string $value = null): void
	{
		$this->currency = $value;
	}

	/**
	 * @param string|null $decSep
	 */
	public function setDecSep(?string $decSep = null): void {
		$this->decSep = $decSep;
	}

	/**
	 * @param int|null $decimals
	 */
	public function setDecimals(?int $decimals = null): void {
		$this->decimals = $decimals;
	}

}