<?php declare(strict_types = 1);

namespace Core\Model\Http;

use Core\Model\BotDetect;

class Session extends \Nette\Http\Session
{
	protected static $botChecked = false;

	public function start(): void
	{
		if (!self::$botChecked && BotDetect::isBot()) {
			session_id(md5('botId'));

			self::$botChecked = true;
		}

		parent::start();
	}

}
