<?php

namespace Core\Model\Router;

use Nette;
use Nette\Application;

class RouteAdmin extends Route
{
	protected $module = 'admin';

	public function setModule($module)
	{
		$this->module = $module;

		return $this;
	}

	public function match(Nette\Http\IRequest $httpRequest)
	{
		$match = parent::match($httpRequest);

		if ($match && strpos($match->getPresenterName(), ':' . ucfirst($this->module) . ':') === false) {
			$name = explode(':', $match->getPresenterName());
			array_splice($name, 1, 0, ucfirst($this->module));
			$match->setPresenterName(implode(':', $name));
		}

		return $match;
	}

	public function constructUrl(Application\Request $appRequest, Nette\Http\Url $refUrl)
	{
		if (strpos($appRequest->getPresenterName(), ':' . ucfirst($this->module) . ':') === false)
			return null;

		$url = parent::constructUrl($appRequest, $refUrl);
		$url = str_replace('.' . strtolower($this->module), '', $url);

		return $url;
	}
}
